%script: proj3
%3d projectile

close all;
disp(' ')
disp('Click the Mouse on the Picture to Continue')
disp('Press a Keyboard Key to Fire!')
vel = input('Velocity of Plane? [0 to 1]: ');
height = 1;

n = ceil(10/vel + 1);
time = linspace(0,1/vel,n)';

x_1 = (vel * time);
y_1 = ones(n,1);
z_1 = height * ones(n,1);

%M = avifile('test3');


view(3)
for m=1:n

   option = waitforbuttonpress;

   % no go
   if option == 0
      hold on
      axis([-.1 1.1 -.1 1.1 -.1 height+.1])
      plot3(x_1(m),y_1(m),z_1(m),'.');
%      w = getframe;
%      M = addframe(M,w);
      hold off
      pause(.1)

   % go
   else
 
      tinit = (m-1)/10;
      [thi,theta,collision] = partial(tinit,vel,height);

      if (theta < atan(2) | theta > pi - atan(2))
%         M = close(M);
     	 disp('Trajectory Not Possible')
         disp(' ')
         close all
    	 break;
      end
      
      tdif = collision - tinit;
      tohit = round(10*(tdif));
      launch_time = (linspace(0,tdif,tohit+1))';
      x_2 = 1/2 + 2*(launch_time)*cos(theta)*cos(thi);
      y_2 = 2*(launch_time)*sin(theta)*cos(thi);
      z_2 = 2*(launch_time)*sin(thi) - (1/2)*(launch_time).*(launch_time);


      for count=1:tohit
      	hold on
        axis([-.1 1.1 -.1 1.1 -.1 height+.1])
        plot3(x_1(m+count-1),y_1(m+count-1),z_1(m+count-1),'.',x_2(count),y_2(count),z_2(count),'x')
%        w = getframe;
%        M = addframe(M,w);
        pause(.1)
      end

      plot3(x_2(count+1),y_2(count+1),z_2(count+1),'r^')
%      w = getframe;
%      M = addframe(M,w);
%      M = close(M);
      hold off
      disp('BOOM!!!!')
      disp(' ')
      break;
   end

end


